#include "LightManager.h"


LightManager::LightManager()
{
}


LightManager::~LightManager()
{
}

void LightManager::AddNewLight(Light* light)
{
	_Lights.push_back(light);	//Push onto the vector
}

void LightManager::UpdateAll(float dt)
{
	for (auto i = _Lights.begin(); i != _Lights.end(); i++)	//Loop through with iterators, call update function
	{
		(*i)->Update(dt);
	}
}

void LightManager::RenderAll()
{
	for (auto i = _Lights.begin(); i != _Lights.end(); i++)	//Loop through with iterators, call overridden render function
	{
		(*i)->Render();
	}
}

void LightManager::ToggleLight(Light* light)
{
	if (light->GetIsOn())	//If the light is on
	{
		//Turn it off, disable the light
		light->SetIsOn(false);
		glDisable(light->GetID());
	}

	else
	{
		//Turn it on, enable the light
		light->SetIsOn(true);
		glEnable(light->GetID());
	}
}